<?php
/* --------------------------------------------------------------
   GambioHubShoppingCartContentView.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioHubShoppingCartContentView extends GambioHubShoppingCartContentView_parent
{
    public function prepare_data()
    {
        if (strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) === 'true') {
            $this->_setPayPalHubButton();
        }
        parent::prepare_data();
    }


    protected function _setPayPalHubButton()
    {
        /** @var \HubPayPalConfiguration $config */
        $config = MainFactory::create('HubPayPalConfiguration');

        $buttonCode = '';

        if ($config->isECS() === true) {
            $text       = MainFactory::create('LanguageTextManager', 'gambio_hub_paypal', $_SESSION['languages_id']);
            $buttonCode .= '<div class="ecs_intro">' . $text->get_text('ecs_button_intro') . '</div>';
            $buttonCode .= '<div id="paypal-button-container"></div>';
        }

        $buttonCode .= '<div class="paypal-installments paypal-installments-cartbottom" data-ppinst-pos="cartBottom"></div>';

        if (isset($_GET['display_mode']) && $_GET['display_mode'] === 'ecs') {
            $this->set_content_data('paypal_ecs_mode', true);
        }

        $this->_setCheckoutButton([
            'script' => $buttonCode,
        ]);
    }


    protected function _getPayPalLocale()
    {
        $paypalLocaleFactory = MainFactory::create('HubPayPalLocaleFactory');
        $locale = $paypalLocaleFactory->getLocaleByLanguageAndCountry($_SESSION['language_code'], $_SESSION['delivery_zone']);
        return $locale;
    }

    protected function _setPayPalInstallments()
    {
        $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
        $moduleInstalled = strtolower((string)@constant('MODULE_PAYMENT_PAYPAL3_INSTALLMENTS_STATUS')) === 'true';
        $moduleInstalled = $moduleInstalled || $hubPayPalConfiguration->isInstallmentsActive();
        if ($moduleInstalled !== true) {
            return;
        }

        $output = '';

        $paypalConfiguration = MainFactory::create('PayPalConfigurationStorage');
        $showSpecific = (bool)$paypalConfiguration->get('show_installments_presentment_specific_cart');
        $showComputed = (bool)$paypalConfiguration->get('show_installments_presentment_specific_computed');
        $amount = $this->sessionCart->show_total();
        $paypalInstallments = MainFactory::create('PayPalInstallments');

        if($showSpecific && $amount >= $paypalInstallments->getMinimumAmount()['amount'] && $amount <= $paypalInstallments->getMaximumAmount()['amount'])
        {
            if($showComputed === true)
            {
                try
                {
                    $response = $paypalInstallments->getInstallmentInfo($amount, $_SESSION['currency'], 'DE');
                    if(!empty($response->financing_options[0]->qualifying_financing_options))
                    {
                        $representativeOption = $paypalInstallments->getRepresentativeOption($response->financing_options[0]->qualifying_financing_options);
                        $specificContentView = MainFactory::create('PayPalInstallmentSpecificUpstreamPresentmentContentView');
                        $specificContentView->qualifyingOptions      = $response->financing_options[0]->qualifying_financing_options;
                        $specificContentView->nonQualifyingOptions   = $response->financing_options[0]->non_qualifying_financing_options;
                        $lender = '';
                        if ($hubPayPalConfiguration->isInstallmentsActive()) {
                            $lender = (string)$hubPayPalConfiguration->getIUPLender();
                        }
                        if ($lender === null || $hubPayPalConfiguration->isInstallmentsActive() !== true) {
                            $lender = implode(
                                ', ',
                                [
                                    COMPANY_NAME,
                                    TRADER_STREET . ' ' . TRADER_STREET_NUMBER,
                                    TRADER_ZIPCODE . ' ' . TRADER_LOCATION,
                                ]
                            );
                        }
                        $specificContentView->lender                      = $lender;
                        $specificContentView->currency               = $_SESSION['currency'];
                        $specificContentView->cashPurchasePrice      = $amount;
                        $specificContentView->numberOfInstallments   = $representativeOption->credit_financing->term;
                        $specificContentView->borrowingRate          = $representativeOption->credit_financing->nominal_rate;
                        $specificContentView->annualPercentageRate   = $representativeOption->credit_financing->apr;
                        $specificContentView->installmentAmount      = $representativeOption->monthly_payment->value;
                        $specificContentView->totalAmount            = $representativeOption->total_cost->value;
                        $specificContentView->representativeFinancingCode = $representativeOption->credit_financing->financing_code;
                        $output = $specificContentView->get_html();
                    }
                }
                catch(Exception $e)
                {
                    $output = sprintf("<!-- PPI Exception -->\n");
                }
            }
            else
            {
                $contentView = MainFactory::create('ContentView');
                $contentView->set_content_template('module/paypalinstallmentspecificstatic.html');
                $contentView->set_flat_assigns(true);
                $contentView->set_caching_enabled(false);
                $contentView->set_content_data('amount', $amount);
                $output = $contentView->get_html();
            }
        }
        else
        {
            $contentView = MainFactory::create('ContentView');
            $contentView->set_content_template('module/paypalinstallmentspecificoutofbounds.html');
            $contentView->set_flat_assigns(true);
            $contentView->set_caching_enabled(false);
            $output = $contentView->get_html();
        }

        $this->set_content_data('PayPalInstallments', $output);

    }

}
